<?php

namespace App\Http\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use Spatie\Activitylog\Models\Activity;
use App\Models\User;

class ActivityLog extends Component
{
    use WithPagination;

    public string $search = '';
    public string $filterUser = '';
    public string $filterAction = '';
    public string $dateFrom = '';
    public string $dateTo = '';
    public int $perPage = 20;

    protected $queryString = ['search', 'filterUser', 'filterAction'];

    public function updatingSearch(): void
    {
        $this->resetPage();
    }

    public function render()
    {
        $activities = Activity::with('causer', 'subject')
            ->when($this->search, function ($q) {
                $q->where('description', 'like', "%{$this->search}%");
            })
            ->when($this->filterUser, fn($q) => $q->where('causer_id', $this->filterUser))
            ->when($this->filterAction, fn($q) => $q->where('event', $this->filterAction))
            ->when($this->dateFrom, fn($q) => $q->whereDate('created_at', '>=', $this->dateFrom))
            ->when($this->dateTo, fn($q) => $q->whereDate('created_at', '<=', $this->dateTo))
            ->latest()
            ->paginate($this->perPage);

        $users = User::orderBy('name')->get(['id', 'name']);

        return view('livewire.admin.activity-log', [
            'activities' => $activities,
            'users' => $users,
        ])->layout('layouts.app', ['title' => 'Bitácora / Auditoría']);
    }
}
