<?php

namespace App\Http\Livewire\Tutorado;

use Livewire\Component;
use App\Models\TutoringSession;
use App\Models\TutorAssignment;
use Illuminate\Support\Facades\Auth;

class Dashboard extends Component
{
    public array $tutorInfo = [];
    public array $ultimasSesiones = [];
    public array $proximaSesion = [];
    public int $totalSesiones = 0;

    public function mount(): void
    {
        $user = Auth::user();

        // Tutor asignado
        $asignacion = TutorAssignment::where('tutorado_id', $user->id)
            ->where('activo', true)
            ->with('tutor')
            ->first();

        if ($asignacion) {
            $this->tutorInfo = [
                'nombre' => $asignacion->tutor->name,
                'email' => $asignacion->tutor->email,
                'telefono' => $asignacion->tutor->telefono,
                'fecha_asignacion' => $asignacion->fecha_asignacion->format('d/m/Y'),
            ];
        }

        // Sesiones
        $this->totalSesiones = TutoringSession::where('tutorado_id', $user->id)
            ->where('estado', 'realizada')
            ->count();

        $this->ultimasSesiones = TutoringSession::where('tutorado_id', $user->id)
            ->with('tutor')
            ->orderByDesc('fecha')
            ->limit(5)
            ->get()
            ->map(fn($s) => [
                'fecha' => $s->fecha->format('d/m/Y'),
                'tema' => $s->temas_tratados,
                'acuerdos' => $s->acuerdos,
                'modalidad' => $s->modalidad_label,
                'estado' => $s->estado,
                'color' => $s->estado_color,
            ])
            ->toArray();

        $proxima = TutoringSession::where('tutorado_id', $user->id)
            ->where('estado', 'pendiente')
            ->where('fecha', '>=', today())
            ->orderBy('fecha')
            ->first();

        if ($proxima) {
            $this->proximaSesion = [
                'fecha' => $proxima->fecha->format('d/m/Y'),
                'tema' => $proxima->temas_tratados,
            ];
        }
    }

    public function render()
    {
        return view('livewire.tutorado.dashboard')
            ->layout('layouts.app', ['title' => 'Mi Portal de Tutoría']);
    }
}
