<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class TutorAssignment extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        'tutor_id',
        'tutorado_id',
        'fecha_asignacion',
        'activo',
        'notas',
        'assigned_by',
    ];

    protected $casts = [
        'fecha_asignacion' => 'date',
        'activo' => 'boolean',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->dontSubmitEmptyLogs();
    }

    public function tutor()
    {
        return $this->belongsTo(User::class, 'tutor_id');
    }

    public function tutorado()
    {
        return $this->belongsTo(User::class, 'tutorado_id');
    }

    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'assigned_by');
    }
}
