<?php

namespace App\Notifications;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TutoradoAsignado extends Notification
{
    use Queueable;

    public function __construct(protected User $tutorado)
    {}

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        return [
            'tipo' => 'tutorado_asignado',
            'mensaje' => "Se te ha asignado un nuevo tutorado: {$this->tutorado->name}",
            'tutorado_id' => $this->tutorado->id,
            'tutorado_nombre' => $this->tutorado->name,
            'tutorado_email' => $this->tutorado->email,
        ];
    }
}
