<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tutoring_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tutor_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('tutorado_id')->constrained('users')->onDelete('cascade');
            $table->date('fecha');
            $table->time('hora_inicio')->nullable();
            $table->time('hora_fin')->nullable();
            $table->string('modalidad')->default('presencial')->comment('presencial, virtual, telefonica');
            $table->string('tipo')->default('individual')->comment('individual, grupal');
            $table->text('temas_tratados');
            $table->text('acuerdos')->nullable();
            $table->text('compromisos_tutorado')->nullable();
            $table->text('compromisos_tutor')->nullable();
            $table->text('observaciones')->nullable();
            $table->string('estado')->default('realizada')->comment('realizada, cancelada, pendiente');
            $table->date('proxima_sesion')->nullable();
            $table->timestamps();

            $table->index(['tutor_id', 'tutorado_id']);
            $table->index(['fecha']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tutoring_sessions');
    }
};
