<!DOCTYPE html>
<html lang="es" class="h-full bg-gray-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $title ?? 'Sistema de Tutorías' }} - Universidad</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles

    {{-- Chart.js --}}
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <style>
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="h-full font-sans antialiased">

<div class="min-h-full">
    {{-- TOP NAVIGATION --}}
    <nav class="bg-blue-900 shadow-lg" x-data="{ mobileOpen: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">

                {{-- Logo / Brand --}}
                <div class="flex items-center">
                    <a href="{{ route('dashboard') }}" class="flex items-center space-x-3">
                        <div class="w-9 h-9 bg-white rounded-lg flex items-center justify-center shadow">
                            <svg class="w-6 h-6 text-blue-900" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M10.394 2.08a1 1 0 00-.788 0l-7 3a1 1 0 000 1.84L5.25 8.051a.999.999 0 01.356-.257l4-1.714a1 1 0 11.788 1.838L7.667 9.088l1.94.831a1 1 0 00.787 0l7-3a1 1 0 000-1.838l-7-3zM3.31 9.397L5 10.12v4.102a8.969 8.969 0 00-1.05-.174 1 1 0 01-.89-.89 11.115 11.115 0 01.25-3.762zM9.3 16.573A9.026 9.026 0 007 14.935v-3.957l1.818.78a3 3 0 002.364 0l5.508-2.361a11.026 11.026 0 01.25 3.762 1 1 0 01-.89.89 8.968 8.968 0 00-5.35 2.524 1 1 0 01-1.4 0zM6 18a1 1 0 001-1v-2.065a8.935 8.935 0 00-2-.712V17a1 1 0 001 1z"/>
                            </svg>
                        </div>
                        <div>
                            <span class="text-white font-bold text-base leading-none">Sistema de Tutorías</span>
                            <span class="text-blue-300 text-xs block leading-none">Portal Institucional</span>
                        </div>
                    </a>

                    {{-- Desktop Nav Links --}}
                    <div class="hidden md:flex ml-10 space-x-1">
                        @auth
                            @if(auth()->user()->hasRole('administrador'))
                                <a href="{{ route('admin.dashboard') }}"
                                   class="@if(request()->routeIs('admin.dashboard')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Dashboard
                                </a>
                                <a href="{{ route('admin.users') }}"
                                   class="@if(request()->routeIs('admin.users')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Usuarios
                                </a>
                                <a href="{{ route('admin.import') }}"
                                   class="@if(request()->routeIs('admin.import')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Importar
                                </a>
                                <a href="{{ route('admin.activitylog') }}"
                                   class="@if(request()->routeIs('admin.activitylog')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Bitácora
                                </a>
                            @elseif(auth()->user()->hasRole('tutor'))
                                <a href="{{ route('tutor.dashboard') }}"
                                   class="@if(request()->routeIs('tutor.dashboard')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Mi Panel
                                </a>
                                <a href="{{ route('tutor.sessions') }}"
                                   class="@if(request()->routeIs('tutor.sessions')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Sesiones
                                </a>
                            @elseif(auth()->user()->hasRole('tutorado'))
                                <a href="{{ route('tutorado.dashboard') }}"
                                   class="@if(request()->routeIs('tutorado.dashboard')) bg-blue-800 text-white @else text-blue-200 hover:bg-blue-800 hover:text-white @endif px-3 py-2 rounded-md text-sm font-medium transition">
                                    Mi Portal
                                </a>
                            @endif
                        @endauth
                    </div>
                </div>

                {{-- Right: User Menu + Notifications --}}
                <div class="flex items-center space-x-3">
                    @auth
                        {{-- Notifications Bell --}}
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="relative text-blue-200 hover:text-white p-2 rounded-full">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                                </svg>
                                @if(auth()->user()->unreadNotifications->count() > 0)
                                    <span class="absolute top-1 right-1 w-4 h-4 bg-red-500 text-white text-xs rounded-full flex items-center justify-center">
                                        {{ auth()->user()->unreadNotifications->count() }}
                                    </span>
                                @endif
                            </button>
                            <div x-show="open" @click.away="open = false" x-cloak
                                 class="absolute right-0 mt-2 w-80 bg-white rounded-xl shadow-xl z-50 border border-gray-100 overflow-hidden">
                                <div class="p-3 bg-gray-50 border-b border-gray-200">
                                    <h3 class="text-sm font-semibold text-gray-700">Notificaciones</h3>
                                </div>
                                <div class="max-h-64 overflow-y-auto">
                                    @forelse(auth()->user()->unreadNotifications->take(5) as $notification)
                                        <div class="p-3 hover:bg-blue-50 border-b border-gray-100 cursor-pointer">
                                            <p class="text-sm text-gray-800">{{ $notification->data['mensaje'] ?? 'Notificación' }}</p>
                                            <p class="text-xs text-gray-400 mt-1">{{ $notification->created_at->diffForHumans() }}</p>
                                        </div>
                                    @empty
                                        <div class="p-4 text-center text-gray-400 text-sm">
                                            Sin notificaciones nuevas
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                        {{-- User Menu --}}
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="flex items-center space-x-2 text-blue-200 hover:text-white">
                                <img class="w-8 h-8 rounded-full ring-2 ring-blue-600"
                                     src="{{ auth()->user()->profile_photo_url }}"
                                     alt="{{ auth()->user()->name }}">
                                <span class="hidden md:block text-sm font-medium">{{ auth()->user()->name }}</span>
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"/>
                                </svg>
                            </button>
                            <div x-show="open" @click.away="open = false" x-cloak
                                 class="absolute right-0 mt-2 w-48 bg-white rounded-xl shadow-xl z-50 border border-gray-100 overflow-hidden">
                                <div class="px-4 py-3 bg-gray-50 border-b border-gray-200">
                                    <p class="text-xs text-gray-500">Conectado como</p>
                                    <p class="text-sm font-semibold text-gray-800 truncate">{{ auth()->user()->name }}</p>
                                    <span class="inline-flex items-center px-2 py-0.5 mt-1 rounded text-xs font-medium
                                        @if(auth()->user()->hasRole('administrador')) bg-purple-100 text-purple-700
                                        @elseif(auth()->user()->hasRole('tutor')) bg-blue-100 text-blue-700
                                        @else bg-green-100 text-green-700 @endif">
                                        {{ auth()->user()->rol_display }}
                                    </span>
                                </div>
                                <a href="{{ route('profile.show') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">Mi Perfil</a>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                        Cerrar Sesión
                                    </button>
                                </form>
                            </div>
                        </div>
                    @endauth
                </div>
            </div>
        </div>
    </nav>

    {{-- FLASH MESSAGES --}}
    @if(session('success'))
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4" x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)">
            <div class="bg-green-50 border border-green-200 rounded-xl p-4 flex items-start space-x-3">
                <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/>
                </svg>
                <p class="text-green-700 text-sm font-medium">{{ session('success') }}</p>
                <button @click="show = false" class="ml-auto text-green-500 hover:text-green-700">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"/></svg>
                </button>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4">
            <div class="bg-red-50 border border-red-200 rounded-xl p-4 flex items-start space-x-3">
                <svg class="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"/>
                </svg>
                <p class="text-red-700 text-sm font-medium">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    {{-- MAIN CONTENT --}}
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        {{ $slot }}
    </main>

    {{-- FOOTER --}}
    <footer class="bg-white border-t border-gray-200 mt-12">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <p class="text-xs text-gray-400">Sistema de Gestión de Tutorías Universitarias</p>
            <p class="text-xs text-gray-400">{{ now()->year }}</p>
        </div>
    </footer>
</div>

@livewireScripts
</body>
</html>
