<div>
    <div class="flex items-center justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Panel de Administración</h1>
            <p class="text-gray-500 text-sm mt-1">Bienvenido, {{ auth()->user()->name }}</p>
        </div>
        <div class="flex space-x-2">
            <a href="{{ route('admin.import') }}"
               class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition shadow-sm">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"/>
                </svg>
                Importar Tutorados
            </a>
            <a href="{{ route('admin.users') }}"
               class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition shadow-sm">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                </svg>
                Gestionar Usuarios
            </a>
        </div>
    </div>

    {{-- METRIC CARDS --}}
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        {{-- Total Tutores --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500 font-medium">Total Tutores</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $totalTutores }}</p>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3z"/>
                    </svg>
                </div>
            </div>
            <p class="text-xs text-blue-500 mt-3">Tutores activos en el sistema</p>
        </div>

        {{-- Total Tutorados --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500 font-medium">Total Tutorados</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $totalTutorados }}</p>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                    </svg>
                </div>
            </div>
            <p class="text-xs text-green-500 mt-3">Estudiantes en tutoría</p>
        </div>

        {{-- Sin asignar --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500 font-medium">Sin Tutor</p>
                    <p class="text-3xl font-bold @if($tutoradosSinAsignar > 0) text-amber-600 @else text-gray-900 @endif mt-1">
                        {{ $tutoradosSinAsignar }}
                    </p>
                </div>
                <div class="w-12 h-12 @if($tutoradosSinAsignar > 0) bg-amber-100 @else bg-gray-100 @endif rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 @if($tutoradosSinAsignar > 0) text-amber-600 @else text-gray-400 @endif" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
            </div>
            <p class="text-xs @if($tutoradosSinAsignar > 0) text-amber-500 @else text-gray-400 @endif mt-3">
                @if($tutoradosSinAsignar > 0) Requieren asignación @else Todos asignados ✓ @endif
            </p>
        </div>

        {{-- Sesiones este mes --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500 font-medium">Sesiones (mes)</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $sesionesEstesMes }}</p>
                </div>
                <div class="w-12 h-12 bg-purple-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
            <p class="text-xs text-purple-500 mt-3">{{ now()->translatedFormat('F Y') }}</p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        {{-- Chart: Tutorados por Tutor --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <h2 class="text-base font-semibold text-gray-900 mb-4">Tutorados por Tutor</h2>
            @if(!empty($chartData['labels']))
                <canvas id="tutoradosChart" height="200"></canvas>
            @else
                <div class="flex items-center justify-center h-40 text-gray-400 text-sm">
                    No hay datos disponibles
                </div>
            @endif
        </div>

        {{-- Actividad Reciente --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-base font-semibold text-gray-900">Actividad Reciente</h2>
                <a href="{{ route('admin.activitylog') }}" class="text-xs text-blue-600 hover:underline">Ver todo</a>
            </div>
            <div class="space-y-3">
                @forelse($actividadReciente as $actividad)
                    <div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
                        <div class="w-2 h-2 bg-blue-400 rounded-full mt-2 flex-shrink-0"></div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm text-gray-800 truncate">{{ $actividad['descripcion'] }}</p>
                            <p class="text-xs text-gray-400 mt-0.5">
                                <span class="font-medium">{{ $actividad['usuario'] }}</span> · {{ $actividad['fecha'] }}
                            </p>
                        </div>
                    </div>
                @empty
                    <p class="text-sm text-gray-400 text-center py-6">Sin actividad reciente</p>
                @endforelse
            </div>
        </div>
    </div>

    {{-- Importaciones Recientes --}}
    @if(!empty($importacionesRecientes))
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-base font-semibold text-gray-900">Importaciones Recientes</h2>
            <a href="{{ route('admin.import') }}" class="text-xs text-blue-600 hover:underline">Nueva importación</a>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left text-xs text-gray-500 uppercase border-b border-gray-200">
                        <th class="pb-3 pr-4">Archivo</th>
                        <th class="pb-3 pr-4">Importado por</th>
                        <th class="pb-3 pr-4">Tutor Asignado</th>
                        <th class="pb-3 pr-4">Creados</th>
                        <th class="pb-3">Fecha</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($importacionesRecientes as $imp)
                    <tr class="hover:bg-gray-50">
                        <td class="py-3 pr-4">
                            <div class="flex items-center space-x-2">
                                <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                                <span class="font-medium text-gray-800">{{ $imp['archivo'] }}</span>
                            </div>
                        </td>
                        <td class="py-3 pr-4 text-gray-600">{{ $imp['por'] }}</td>
                        <td class="py-3 pr-4 text-gray-600">{{ $imp['tutor'] }}</td>
                        <td class="py-3 pr-4">
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700">
                                {{ $imp['creados'] }} creados
                            </span>
                        </td>
                        <td class="py-3 text-gray-500">{{ $imp['fecha'] }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('tutoradosChart');
    if (!ctx) return;

    const chartData = @json($chartData);

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels,
            datasets: [{
                label: 'Tutorados asignados',
                data: chartData.data,
                backgroundColor: 'rgba(37, 99, 235, 0.7)',
                borderColor: 'rgba(37, 99, 235, 1)',
                borderWidth: 1,
                borderRadius: 6,
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { stepSize: 1 }
                }
            }
        }
    });
});
</script>
@endpush
