<div>
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Sesiones de Tutoría</h1>
            <p class="text-gray-500 text-sm mt-1">Registro y seguimiento de sesiones con tutorados</p>
        </div>
        <button wire:click="openCreateModal"
                class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition shadow-sm">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Registrar Sesión
        </button>
    </div>

    {{-- Filters --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <select wire:model="filterTutorado" class="text-sm border-gray-300 rounded-xl focus:border-blue-500">
                <option value="">Todos mis tutorados</option>
                @foreach($misTutorados as $t)
                    <option value="{{ $t->id }}">{{ $t->name }}</option>
                @endforeach
            </select>
            <select wire:model="filterEstado" class="text-sm border-gray-300 rounded-xl focus:border-blue-500">
                <option value="">Todos los estados</option>
                <option value="realizada">Realizada</option>
                <option value="pendiente">Pendiente</option>
                <option value="cancelada">Cancelada</option>
            </select>
            <input type="month" wire:model="filterMes" class="text-sm border-gray-300 rounded-xl focus:border-blue-500">
        </div>
    </div>

    {{-- Sessions List --}}
    <div class="space-y-4">
        @forelse($sessions as $session)
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5 hover:border-blue-100 transition">
            <div class="flex items-start justify-between">
                <div class="flex items-start space-x-4 flex-1">
                    <div class="w-12 h-12 bg-blue-600 rounded-xl flex flex-col items-center justify-center text-white flex-shrink-0">
                        <span class="text-lg font-bold leading-none">{{ $session->fecha->format('d') }}</span>
                        <span class="text-xs uppercase">{{ $session->fecha->format('M') }}</span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center space-x-2 mb-1">
                            <h3 class="font-semibold text-gray-900 text-sm">{{ $session->tutorado->name }}</h3>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                @if($session->estado === 'realizada') bg-green-100 text-green-700
                                @elseif($session->estado === 'pendiente') bg-yellow-100 text-yellow-700
                                @else bg-red-100 text-red-700 @endif">
                                {{ ucfirst($session->estado) }}
                            </span>
                            <span class="text-xs text-gray-400 capitalize">· {{ $session->modalidad }}</span>
                        </div>
                        <p class="text-sm text-gray-700 mb-2">{{ Str::limit($session->temas_tratados, 120) }}</p>
                        @if($session->acuerdos)
                        <p class="text-xs text-gray-500">
                            <strong>Acuerdos:</strong> {{ Str::limit($session->acuerdos, 100) }}
                        </p>
                        @endif
                        @if($session->proxima_sesion)
                        <p class="text-xs text-blue-600 mt-1">
                            📅 Próxima sesión: {{ $session->proxima_sesion->format('d/m/Y') }}
                        </p>
                        @endif
                    </div>
                </div>
                <div class="flex items-center space-x-1 ml-4">
                    <button wire:click="openEditModal({{ $session->id }})"
                            class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                        </svg>
                    </button>
                    <button wire:click="deleteSession({{ $session->id }})"
                            wire:confirm="¿Eliminar esta sesión?"
                            class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        @empty
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-12 text-center text-gray-400">
            <svg class="w-14 h-14 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
            </svg>
            <p class="font-medium text-gray-600">No hay sesiones registradas</p>
            <p class="text-sm mt-1">Registra tu primera sesión de tutoría</p>
            <button wire:click="openCreateModal"
                    class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                Registrar Primera Sesión
            </button>
        </div>
        @endforelse
    </div>

    <div class="mt-4">{{ $sessions->links() }}</div>

    {{-- ===================== MODAL: Session Form ===================== --}}
    @if($showModal)
    <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4 overflow-y-auto" wire:click.self="$set('showModal', false)">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-2xl my-4 overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                <h3 class="text-base font-semibold text-gray-900">
                    {{ $editMode ? 'Editar Sesión' : 'Registrar Nueva Sesión' }}
                </h3>
                <button wire:click="$set('showModal', false)" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"/>
                    </svg>
                </button>
            </div>
            <div class="p-6 space-y-4 max-h-[70vh] overflow-y-auto">
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Tutorado *</label>
                        <select wire:model="tutorado_id" class="w-full text-sm border-gray-300 rounded-xl">
                            <option value="">-- Seleccionar --</option>
                            @foreach($misTutorados as $t)
                                <option value="{{ $t->id }}">{{ $t->name }}</option>
                            @endforeach
                        </select>
                        @error('tutorado_id') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Fecha *</label>
                        <input type="date" wire:model="fecha" class="w-full text-sm border-gray-300 rounded-xl">
                        @error('fecha') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>
                </div>
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Hora inicio</label>
                        <input type="time" wire:model="hora_inicio" class="w-full text-sm border-gray-300 rounded-xl">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Hora fin</label>
                        <input type="time" wire:model="hora_fin" class="w-full text-sm border-gray-300 rounded-xl">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
                        <select wire:model="estado" class="w-full text-sm border-gray-300 rounded-xl">
                            <option value="realizada">Realizada</option>
                            <option value="pendiente">Pendiente</option>
                            <option value="cancelada">Cancelada</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Modalidad</label>
                        <select wire:model="modalidad" class="w-full text-sm border-gray-300 rounded-xl">
                            <option value="presencial">Presencial</option>
                            <option value="virtual">Virtual</option>
                            <option value="telefonica">Telefónica</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Próxima sesión</label>
                        <input type="date" wire:model="proxima_sesion" class="w-full text-sm border-gray-300 rounded-xl">
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Temas tratados *</label>
                    <textarea wire:model="temas_tratados" rows="3"
                              class="w-full text-sm border-gray-300 rounded-xl resize-none"
                              placeholder="Describe los temas abordados en la sesión..."></textarea>
                    @error('temas_tratados') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Acuerdos</label>
                    <textarea wire:model="acuerdos" rows="2"
                              class="w-full text-sm border-gray-300 rounded-xl resize-none"
                              placeholder="Acuerdos alcanzados en la sesión..."></textarea>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Compromisos del tutorado</label>
                        <textarea wire:model="compromisos_tutorado" rows="2"
                                  class="w-full text-sm border-gray-300 rounded-xl resize-none"></textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Compromisos del tutor</label>
                        <textarea wire:model="compromisos_tutor" rows="2"
                                  class="w-full text-sm border-gray-300 rounded-xl resize-none"></textarea>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Observaciones adicionales</label>
                    <textarea wire:model="observaciones" rows="2"
                              class="w-full text-sm border-gray-300 rounded-xl resize-none"
                              placeholder="Observaciones adicionales..."></textarea>
                </div>
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                <button wire:click="$set('showModal', false)" class="px-4 py-2 border border-gray-300 text-gray-700 text-sm rounded-lg hover:bg-gray-100">Cancelar</button>
                <button wire:click="save" class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    {{ $editMode ? 'Guardar Cambios' : 'Registrar Sesión' }}
                </button>
            </div>
        </div>
    </div>
    @endif
</div>
