<?php

use Illuminate\Support\Facades\Route;
use App\Http\Livewire\Admin\Dashboard as AdminDashboard;
use App\Http\Livewire\Admin\UserManagement;
use App\Http\Livewire\Admin\ImportTutorados;
use App\Http\Livewire\Admin\ActivityLog;
use App\Http\Livewire\Tutor\Dashboard as TutorDashboard;
use App\Http\Livewire\Tutor\SessionManager;
use App\Http\Livewire\Tutorado\Dashboard as TutoradoDashboard;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\UsersExport;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/
Route::get('/', function () {
    if (Auth::check()) {
        return redirect()->route('dashboard');
    }
    return redirect()->route('login');
});

/*
|--------------------------------------------------------------------------
| Auth Routes (Jetstream handles these)
|--------------------------------------------------------------------------
*/
// Jetstream provides: /login, /register, /forgot-password, /profile

/*
|--------------------------------------------------------------------------
| Authenticated Routes
|--------------------------------------------------------------------------
*/
Route::middleware(['auth:sanctum', 'verified'])->group(function () {

    // Generic dashboard redirect based on role
    Route::get('/dashboard', function () {
        $user = Auth::user();
        if ($user->hasRole('administrador')) {
            return redirect()->route('admin.dashboard');
        } elseif ($user->hasRole('tutor')) {
            return redirect()->route('tutor.dashboard');
        } else {
            return redirect()->route('tutorado.dashboard');
        }
    })->name('dashboard');

    /*
    |----------------------------------------------------------------------
    | ADMIN ROUTES
    |----------------------------------------------------------------------
    */
    Route::middleware(['role:administrador'])->prefix('admin')->name('admin.')->group(function () {
        Route::get('/dashboard', AdminDashboard::class)->name('dashboard');
        Route::get('/usuarios', UserManagement::class)->name('users');
        Route::get('/importar', ImportTutorados::class)->name('import');
        Route::get('/bitacora', ActivityLog::class)->name('activitylog');

        // Export route
        Route::get('/exportar/usuarios', function () {
            $tutorId = request('tutor_id');
            return Excel::download(
                new UsersExport($tutorId),
                'tutorados_' . now()->format('Y-m-d') . '.xlsx'
            );
        })->name('export.users');

        // Export filtered by tutor
        Route::get('/exportar/tutor/{tutorId}', function ($tutorId) {
            return Excel::download(
                new UsersExport($tutorId),
                'tutorados_tutor_' . $tutorId . '_' . now()->format('Y-m-d') . '.xlsx'
            );
        })->name('export.tutor');
    });

    /*
    |----------------------------------------------------------------------
    | TUTOR ROUTES
    |----------------------------------------------------------------------
    */
    Route::middleware(['role:tutor'])->prefix('tutor')->name('tutor.')->group(function () {
        Route::get('/dashboard', TutorDashboard::class)->name('dashboard');
        Route::get('/sesiones', SessionManager::class)->name('sessions');
    });

    /*
    |----------------------------------------------------------------------
    | TUTORADO ROUTES
    |----------------------------------------------------------------------
    */
    Route::middleware(['role:tutorado'])->prefix('tutorado')->name('tutorado.')->group(function () {
        Route::get('/dashboard', TutoradoDashboard::class)->name('dashboard');
    });
});
