# Sistema de Gestión de Tutorías Universitarias

Sistema web full-stack para la gestión de tutorías universitarias, construido con **Laravel 11 + Livewire v3 + Jetstream + MySQL**.

---

## Stack Tecnológico

- **Laravel 11** (PHP 8.2+)
- **Livewire v3**
- **Jetstream** (stack Livewire)
- **MySQL 8+**
- **spatie/laravel-permission** — Roles y permisos
- **maatwebsite/excel** — Importación/Exportación Excel/CSV
- **barryvdh/laravel-dompdf** — Generación de PDF
- **spatie/laravel-activitylog** — Auditoría/Bitácora
- **Tailwind CSS** — UI
- **Chart.js** — Gráficas en Dashboard

---

## Requisitos

- PHP >= 8.2
- Composer
- Node.js >= 18 & npm
- MySQL 8+

---

## Instalación paso a paso

### 1. Crear proyecto Laravel con Jetstream

```bash
composer create-project laravel/laravel tutoring-app
cd tutoring-app
composer require laravel/jetstream
php artisan jetstream:install livewire --teams
```

### 2. Instalar dependencias del sistema

```bash
composer require spatie/laravel-permission
composer require maatwebsite/excel
composer require barryvdh/laravel-dompdf
composer require spatie/laravel-activitylog
```

### 3. Copiar archivos de este repositorio

Copia todos los archivos de este proyecto sobre tu instalación de Laravel:

```bash
# Migraciones
cp database/migrations/* your-app/database/migrations/

# Modelos
cp app/Models/* your-app/app/Models/

# Livewire Components
cp -r app/Http/Livewire/* your-app/app/Http/Livewire/

# Vistas
cp -r resources/views/* your-app/resources/views/

# Rutas
cp routes/web.php your-app/routes/web.php

# Imports/Exports
cp app/Imports/* your-app/app/Imports/
cp app/Exports/* your-app/app/Exports/

# Notificaciones
cp app/Notifications/* your-app/app/Notifications/

# Seeders
cp database/seeders/* your-app/database/seeders/
```

### 4. Configurar .env

```env
APP_NAME="Sistema de Tutorías"
APP_URL=http://localhost:8000

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=tutoring_db
DB_USERNAME=root
DB_PASSWORD=secret

MAIL_MAILER=smtp
MAIL_HOST=mailpit
MAIL_PORT=1025
```

### 5. Publicar configuraciones

```bash
php artisan vendor:publish --provider="Spatie\Permission\PermissionServiceProvider"
php artisan vendor:publish --provider="Spatie\Activitylog\ActivitylogServiceProvider" --tag="activitylog-migrations"
php artisan vendor:publish --provider="Maatwebsite\Excel\ExcelServiceProvider" --tag=config
```

### 6. Ejecutar migraciones y seeders

```bash
php artisan migrate
php artisan db:seed
```

### 7. Compilar assets

```bash
npm install
npm run build
```

### 8. Iniciar servidor

```bash
php artisan serve
```

---

## Credenciales por defecto (Seeder)

| Rol           | Email                        | Contraseña   |
|---------------|------------------------------|--------------|
| Administrador | admin@universidad.edu        | Admin1234!   |
| Tutor         | tutor1@universidad.edu       | Tutor1234!   |
| Tutorado      | tutorado1@universidad.edu    | Tut1234!     |

---

## Roles y Permisos

### Administrador
- CRUD completo de usuarios (tutores y tutorados)
- Importación masiva desde CSV/XLSX con preview
- Asignación de tutor a tutorados (individual y masiva)
- Exportación de usuarios filtrados por tutor
- Restablecer contraseñas
- Ver bitácora/auditoría completa
- Ver credenciales generadas en importación
- Configuración básica del sistema

### Tutor
- Ver sus tutorados asignados
- Ver expediente de sus tutorados
- Registrar y ver sesiones/seguimientos
- Ver historial de actividades de sus tutorados

### Tutorado
- Ver su tutor asignado
- Ver su historial de sesiones
- Editar datos personales básicos

---

## Módulos del Sistema

### A. Autenticación
- Login institucional con código o correo
- Recuperación de contraseña
- Perfil de usuario (Jetstream)
- Rate limiting en login
- Protección de rutas por rol

### B. Dashboards por Rol
- Dashboard Administrador con métricas y gráficas
- Dashboard Tutor con sus tutorados
- Dashboard Tutorado con su información

### C. Gestión de Usuarios
- CRUD completo con paginación
- Filtros por rol, estado, tutor
- Búsqueda por código, nombre, correo
- Activar/desactivar cuentas

### D. Importación Masiva (Livewire)
- Carga de archivo CSV/XLSX
- Preview de registros antes de confirmar
- Validación de estructura y datos
- Selección de tutor para asignación masiva
- Generación de contraseñas temporales
- Resultado detallado: creados/actualizados/omitidos/errores
- Vista de credenciales generadas (solo admin)

### E. Expediente del Tutorado
- Datos personales básicos
- Información académica
- Historial de sesiones

### F. Sesiones de Tutoría
- Registro de sesiones con fecha, tema, acuerdos
- Historial por tutorado
- Notas y seguimiento

### G. Notificaciones
- Notificaciones internas (database)
- Alertas de nuevas asignaciones
- Recordatorios de sesiones

### H. Bitácora / Auditoría
- Registro de todas las acciones importantes
- Filtros por usuario, acción, fecha
- Solo visible para Administrador

---

## Estructura de Archivos del Proyecto

```
tutoring-app/
├── app/
│   ├── Http/
│   │   └── Livewire/
│   │       ├── Admin/
│   │       │   ├── UserManagement.php
│   │       │   ├── ImportTutorados.php
│   │       │   ├── AssignTutor.php
│   │       │   ├── ActivityLog.php
│   │       │   └── Dashboard.php
│   │       ├── Tutor/
│   │       │   ├── Dashboard.php
│   │       │   ├── TutoradoList.php
│   │       │   └── SessionManager.php
│   │       └── Tutorado/
│   │           ├── Dashboard.php
│   │           └── Profile.php
│   ├── Models/
│   │   ├── User.php
│   │   ├── TutoradoProfile.php
│   │   ├── TutorAssignment.php
│   │   └── TutoringSession.php
│   ├── Imports/
│   │   └── TutoradosImport.php
│   └── Exports/
│       └── UsersExport.php
├── database/
│   ├── migrations/
│   └── seeders/
└── resources/views/
    ├── layouts/
    ├── admin/
    ├── tutor/
    └── tutorado/
```

---

## Docker (Opcional)

```bash
cp docker-compose.yml.example docker-compose.yml
docker-compose up -d
docker-compose exec app php artisan migrate --seed
```

---

## Consideraciones de Seguridad

- Contraseñas hasheadas con bcrypt
- Rate limiting en login (5 intentos/minuto)
- Protección CSRF en todos los formularios
- Validación server-side con Form Requests
- Políticas de acceso por rol con Spatie Permission
- Logs de auditoría para acciones sensibles
