<?php

namespace App\Exports;

use App\Models\User;
use App\Models\TutorAssignment;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class UsersExport implements FromCollection, WithHeadings, WithMapping, WithTitle, WithStyles, ShouldAutoSize
{
    protected ?int $tutorId;
    protected string $rol;

    public function __construct(?int $tutorId = null, string $rol = 'tutorado')
    {
        $this->tutorId = $tutorId;
        $this->rol = $rol;
    }

    public function collection()
    {
        return User::role($this->rol)
            ->when($this->tutorId, function ($q) {
                $q->whereHas('tutorAsignado', fn($q) => $q->where('tutor_id', $this->tutorId));
            })
            ->with(['roles', 'tutorAsignado.tutor', 'perfil'])
            ->orderBy('name')
            ->get();
    }

    public function headings(): array
    {
        return [
            'ID',
            'Código',
            'Nombre',
            'Email',
            'Teléfono',
            'Carrera',
            'Semestre',
            'Tutor Asignado',
            'Estado',
            'Fecha Registro',
        ];
    }

    public function map($user): array
    {
        return [
            $user->id,
            $user->codigo ?? 'N/A',
            $user->name,
            $user->email,
            $user->telefono ?? 'N/A',
            $user->perfil?->carrera ?? $user->carrera ?? 'N/A',
            $user->perfil?->semestre ?? $user->semestre ?? 'N/A',
            $user->tutorAsignado?->tutor?->name ?? 'Sin asignar',
            $user->activo ? 'Activo' : 'Inactivo',
            $user->created_at->format('d/m/Y'),
        ];
    }

    public function title(): string
    {
        return 'Tutorados';
    }

    public function styles(Worksheet $sheet): array
    {
        return [
            1 => [
                'font' => ['bold' => true, 'color' => ['argb' => 'FFFFFFFF']],
                'fill' => ['fillType' => 'solid', 'startColor' => ['argb' => 'FF1E40AF']],
            ],
        ];
    }
}
