<?php

namespace App\Http\Livewire\Tutor;

use Livewire\Component;
use App\Models\TutorAssignment;
use App\Models\TutoringSession;
use Illuminate\Support\Facades\Auth;

class Dashboard extends Component
{
    public int $totalTutorados = 0;
    public int $sesionesEsteMes = 0;
    public int $tutoradosRecientes = 0;
    public array $proximasSesiones = [];
    public array $ultimasActividades = [];
    public array $tutoradosLista = [];

    public function mount(): void
    {
        $tutorId = Auth::id();

        $this->totalTutorados = TutorAssignment::where('tutor_id', $tutorId)
            ->where('activo', true)
            ->count();

        $this->sesionesEsteMes = TutoringSession::where('tutor_id', $tutorId)
            ->whereMonth('fecha', now()->month)
            ->count();

        $this->tutoradosRecientes = TutorAssignment::where('tutor_id', $tutorId)
            ->where('activo', true)
            ->where('fecha_asignacion', '>=', now()->subDays(30))
            ->count();

        $this->proximasSesiones = TutoringSession::where('tutor_id', $tutorId)
            ->where('estado', 'pendiente')
            ->where('fecha', '>=', today())
            ->with('tutorado')
            ->orderBy('fecha')
            ->limit(5)
            ->get()
            ->map(fn($s) => [
                'tutorado' => $s->tutorado->name,
                'fecha' => $s->fecha->format('d/m/Y'),
                'tema' => $s->temas_tratados,
            ])
            ->toArray();

        $this->tutoradosLista = TutorAssignment::where('tutor_id', $tutorId)
            ->where('activo', true)
            ->with('tutorado.perfil')
            ->latest('fecha_asignacion')
            ->limit(10)
            ->get()
            ->map(fn($a) => [
                'id' => $a->tutorado->id,
                'nombre' => $a->tutorado->name,
                'email' => $a->tutorado->email,
                'codigo' => $a->tutorado->codigo,
                'carrera' => $a->tutorado->perfil?->carrera,
                'estado' => $a->tutorado->perfil?->estado_academico ?? 'regular',
                'fecha_asignacion' => $a->fecha_asignacion->format('d/m/Y'),
            ])
            ->toArray();
    }

    public function render()
    {
        return view('livewire.tutor.dashboard')
            ->layout('layouts.app', ['title' => 'Mi Panel - Tutor']);
    }
}
