<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TutoradoProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'numero_control',
        'carrera',
        'semestre',
        'turno',
        'fecha_ingreso',
        'promedio_general',
        'estado_academico',
        'observaciones_generales',
        'fecha_nacimiento',
        'genero',
        'estado_civil',
        'direccion',
        'municipio',
        'estado',
        'contacto_emergencia_nombre',
        'contacto_emergencia_telefono',
        'contacto_emergencia_parentesco',
        'beca',
        'tipo_beca',
        'trabaja',
    ];

    protected $casts = [
        'fecha_ingreso' => 'date',
        'fecha_nacimiento' => 'date',
        'beca' => 'boolean',
        'trabaja' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getEdadAttribute(): ?int
    {
        return $this->fecha_nacimiento?->age;
    }

    public function getEstadoAcademicoLabelAttribute(): string
    {
        return match($this->estado_academico) {
            'regular' => 'Regular',
            'irregular' => 'Irregular',
            'baja_temporal' => 'Baja Temporal',
            'baja_definitiva' => 'Baja Definitiva',
            default => 'Regular',
        };
    }

    public function getEstadoAcademicoColorAttribute(): string
    {
        return match($this->estado_academico) {
            'regular' => 'green',
            'irregular' => 'yellow',
            'baja_temporal' => 'orange',
            'baja_definitiva' => 'red',
            default => 'gray',
        };
    }
}
