<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class TutoringSession extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        'tutor_id',
        'tutorado_id',
        'fecha',
        'hora_inicio',
        'hora_fin',
        'modalidad',
        'tipo',
        'temas_tratados',
        'acuerdos',
        'compromisos_tutorado',
        'compromisos_tutor',
        'observaciones',
        'estado',
        'proxima_sesion',
    ];

    protected $casts = [
        'fecha' => 'date',
        'proxima_sesion' => 'date',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->dontSubmitEmptyLogs();
    }

    public function tutor()
    {
        return $this->belongsTo(User::class, 'tutor_id');
    }

    public function tutorado()
    {
        return $this->belongsTo(User::class, 'tutorado_id');
    }

    public function getModalidadLabelAttribute(): string
    {
        return match($this->modalidad) {
            'presencial' => 'Presencial',
            'virtual' => 'Virtual',
            'telefonica' => 'Telefónica',
            default => 'Presencial',
        };
    }

    public function getEstadoColorAttribute(): string
    {
        return match($this->estado) {
            'realizada' => 'green',
            'cancelada' => 'red',
            'pendiente' => 'yellow',
            default => 'gray',
        };
    }

    public function scopeRealizadas($query)
    {
        return $query->where('estado', 'realizada');
    }

    public function scopePendientes($query)
    {
        return $query->where('estado', 'pendiente');
    }
}
