<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tutor_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tutor_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('tutorado_id')->constrained('users')->onDelete('cascade');
            $table->date('fecha_asignacion');
            $table->boolean('activo')->default(true);
            $table->text('notas')->nullable();
            $table->foreignId('assigned_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();

            $table->unique(['tutorado_id']); // Un tutorado solo puede tener un tutor activo
            $table->index(['tutor_id', 'activo']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tutor_assignments');
    }
};
