<div>
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Bitácora / Auditoría</h1>
            <p class="text-gray-500 text-sm mt-1">Registro completo de acciones en el sistema</p>
        </div>
    </div>

    {{-- Filters --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="md:col-span-2">
                <input type="text" wire:model.debounce.300ms="search"
                       placeholder="Buscar en descripción..."
                       class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500">
            </div>
            <select wire:model="filterUser" class="text-sm border-gray-300 rounded-xl focus:border-blue-500">
                <option value="">Todos los usuarios</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            <input type="date" wire:model="dateFrom"
                   class="text-sm border-gray-300 rounded-xl focus:border-blue-500">
        </div>
    </div>

    {{-- Activity Table --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50 border-b border-gray-200">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Acción</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Realizó</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Sujeto</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Propiedades</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Fecha</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($activities as $activity)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                @if(str_contains($activity->description, 'creado')) bg-green-100 text-green-700
                                @elseif(str_contains($activity->description, 'eliminado')) bg-red-100 text-red-700
                                @elseif(str_contains($activity->description, 'actualizado')) bg-blue-100 text-blue-700
                                @else bg-gray-100 text-gray-700 @endif">
                                {{ $activity->description }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-gray-700">
                            {{ $activity->causer?->name ?? 'Sistema' }}
                        </td>
                        <td class="px-4 py-3 text-gray-500 text-xs">
                            {{ class_basename($activity->subject_type ?? 'N/A') }}
                            @if($activity->subject_id) #{{ $activity->subject_id }} @endif
                        </td>
                        <td class="px-4 py-3 max-w-xs">
                            @if($activity->properties->isNotEmpty())
                                <details class="text-xs text-gray-500 cursor-pointer">
                                    <summary class="text-blue-600 hover:underline">Ver cambios</summary>
                                    <pre class="mt-1 bg-gray-50 rounded p-2 text-xs overflow-x-auto max-w-xs">{{ json_encode($activity->properties, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                                </details>
                            @else
                                <span class="text-gray-300">—</span>
                            @endif
                        </td>
                        <td class="px-4 py-3 text-gray-400 text-xs whitespace-nowrap">
                            {{ $activity->created_at->format('d/m/Y H:i:s') }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-4 py-12 text-center text-gray-400">
                            <p class="font-medium">No se encontraron registros</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-4 py-3 border-t border-gray-200">
            {{ $activities->links() }}
        </div>
    </div>
</div>
