<div>
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-900">Mi Portal de Tutoría</h1>
        <p class="text-gray-500 text-sm mt-1">Hola, {{ auth()->user()->name }} 👋</p>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Tutor Info Card --}}
        <div class="lg:col-span-1">
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-base font-semibold text-gray-900 mb-4">Mi Tutor</h2>
                @if(!empty($tutorInfo))
                <div class="text-center mb-4">
                    <div class="w-16 h-16 rounded-full bg-gradient-to-br from-blue-500 to-blue-700 flex items-center justify-center text-white text-2xl font-bold mx-auto mb-3">
                        {{ strtoupper(substr($tutorInfo['nombre'], 0, 1)) }}
                    </div>
                    <h3 class="font-semibold text-gray-900">{{ $tutorInfo['nombre'] }}</h3>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-700 mt-1">
                        Tutor Asignado
                    </span>
                </div>
                <div class="space-y-2 text-sm">
                    <div class="flex items-center space-x-2 text-gray-600">
                        <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        <span class="truncate">{{ $tutorInfo['email'] }}</span>
                    </div>
                    @if($tutorInfo['telefono'])
                    <div class="flex items-center space-x-2 text-gray-600">
                        <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                        </svg>
                        <span>{{ $tutorInfo['telefono'] }}</span>
                    </div>
                    @endif
                    <div class="text-xs text-gray-400 mt-2">
                        Asignado desde: {{ $tutorInfo['fecha_asignacion'] }}
                    </div>
                </div>
                @else
                <div class="text-center py-6 text-gray-400">
                    <svg class="w-12 h-12 mx-auto mb-2 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    <p class="text-sm font-medium">Sin tutor asignado</p>
                    <p class="text-xs mt-1">Contacta a administración</p>
                </div>
                @endif
            </div>

            {{-- Stats --}}
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mt-4">
                <h2 class="text-base font-semibold text-gray-900 mb-4">Mi Progreso</h2>
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Sesiones realizadas</span>
                        <span class="text-lg font-bold text-blue-600">{{ $totalSesiones }}</span>
                    </div>
                    @if(!empty($proximaSesion))
                    <div class="bg-blue-50 rounded-xl p-3 mt-2">
                        <p class="text-xs font-semibold text-blue-800 mb-1">Próxima sesión</p>
                        <p class="text-sm text-blue-700 font-medium">{{ $proximaSesion['fecha'] }}</p>
                        <p class="text-xs text-blue-500 truncate">{{ $proximaSesion['tema'] }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Session History --}}
        <div class="lg:col-span-2">
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-base font-semibold text-gray-900 mb-4">Historial de Sesiones</h2>
                @forelse($ultimasSesiones as $sesion)
                <div class="border border-gray-200 rounded-xl p-4 mb-4 hover:border-blue-200 transition">
                    <div class="flex items-start justify-between mb-2">
                        <div class="flex items-center space-x-2">
                            <span class="text-sm font-semibold text-gray-900">{{ $sesion['fecha'] }}</span>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                bg-{{ $sesion['color'] }}-100 text-{{ $sesion['color'] }}-700">
                                {{ ucfirst($sesion['estado']) }}
                            </span>
                        </div>
                        <span class="text-xs text-gray-400 capitalize">{{ $sesion['modalidad'] }}</span>
                    </div>
                    <p class="text-sm text-gray-700 mb-2">{{ $sesion['tema'] }}</p>
                    @if($sesion['acuerdos'])
                    <div class="bg-gray-50 rounded-lg px-3 py-2">
                        <p class="text-xs text-gray-500 font-medium mb-1">Acuerdos:</p>
                        <p class="text-xs text-gray-600">{{ $sesion['acuerdos'] }}</p>
                    </div>
                    @endif
                </div>
                @empty
                <div class="text-center py-12 text-gray-400">
                    <svg class="w-12 h-12 mx-auto mb-3 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                    <p class="font-medium">Sin sesiones registradas</p>
                    <p class="text-sm mt-1">Tus sesiones de tutoría aparecerán aquí</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
