<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ImportLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'imported_by',
        'tutor_id',
        'filename',
        'total_rows',
        'created',
        'updated',
        'skipped',
        'errors',
        'error_details',
        'credentials_generated',
        'status',
    ];

    protected $casts = [
        'error_details' => 'array',
        'credentials_generated' => 'array',
    ];

    public function importedBy()
    {
        return $this->belongsTo(User::class, 'imported_by');
    }

    public function tutor()
    {
        return $this->belongsTo(User::class, 'tutor_id');
    }
}
