<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tutorado_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('numero_control')->nullable();
            $table->string('carrera')->nullable();
            $table->string('semestre')->nullable();
            $table->string('turno')->nullable()->comment('Matutino, Vespertino, Mixto');
            $table->date('fecha_ingreso')->nullable();
            $table->string('promedio_general')->nullable();
            $table->string('estado_academico')->default('regular')->comment('regular, irregular, baja_temporal, baja_definitiva');
            $table->text('observaciones_generales')->nullable();

            // Datos personales adicionales
            $table->date('fecha_nacimiento')->nullable();
            $table->string('genero')->nullable();
            $table->string('estado_civil')->nullable();
            $table->text('direccion')->nullable();
            $table->string('municipio')->nullable();
            $table->string('estado')->nullable();

            // Datos de contacto de emergencia
            $table->string('contacto_emergencia_nombre')->nullable();
            $table->string('contacto_emergencia_telefono')->nullable();
            $table->string('contacto_emergencia_parentesco')->nullable();

            // Situación socioeconómica (opcional)
            $table->boolean('beca')->default(false);
            $table->string('tipo_beca')->nullable();
            $table->boolean('trabaja')->default(false);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tutorado_profiles');
    }
};
