<div>
    <div class="flex items-center justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Importación Masiva de Tutorados</h1>
            <p class="text-gray-500 text-sm mt-1">Carga un archivo CSV o Excel para registrar tutorados en masa</p>
        </div>
    </div>

    {{-- STEPPER --}}
    <div class="mb-8">
        <div class="flex items-center justify-center space-x-2">
            @foreach([1 => 'Cargar Archivo', 2 => 'Vista Previa', 3 => 'Asignar Tutor', 4 => 'Resultados'] as $num => $label)
                <div class="flex items-center">
                    <div class="flex flex-col items-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold
                            @if($step > $num) bg-green-500 text-white
                            @elseif($step == $num) bg-blue-600 text-white ring-4 ring-blue-100
                            @else bg-gray-200 text-gray-500 @endif">
                            @if($step > $num)
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"/>
                                </svg>
                            @else
                                {{ $num }}
                            @endif
                        </div>
                        <span class="text-xs mt-1 font-medium
                            @if($step == $num) text-blue-600 @elseif($step > $num) text-green-600 @else text-gray-400 @endif">
                            {{ $label }}
                        </span>
                    </div>
                    @if($num < 4)
                        <div class="w-16 h-0.5 mb-5 @if($step > $num) bg-green-400 @else bg-gray-200 @endif mx-2"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>

    {{-- ===================== STEP 1: UPLOAD ===================== --}}
    @if($step == 1)
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 max-w-2xl mx-auto">
        <h2 class="text-lg font-semibold text-gray-900 mb-2">Paso 1: Cargar Archivo</h2>
        <p class="text-sm text-gray-500 mb-6">Sube un archivo CSV o Excel (.xlsx) con los datos de los tutorados.</p>

        {{-- Format Info --}}
        <div class="bg-blue-50 rounded-xl p-4 mb-6">
            <h3 class="text-sm font-semibold text-blue-900 mb-2">Formato requerido del archivo:</h3>
            <div class="overflow-x-auto">
                <table class="text-xs w-full">
                    <thead>
                        <tr class="text-blue-800">
                            <th class="text-left pr-4 pb-1">Columna</th>
                            <th class="text-left pr-4 pb-1">Requerida</th>
                            <th class="text-left pb-1">Descripción</th>
                        </tr>
                    </thead>
                    <tbody class="text-blue-700 divide-y divide-blue-200">
                        <tr><td class="pr-4 py-1 font-mono">nombre</td><td class="pr-4">✅ Sí</td><td>Nombre completo</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">email</td><td class="pr-4">✅ Sí</td><td>Correo institucional</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">codigo</td><td class="pr-4">Opcional</td><td>Código de estudiante</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">telefono</td><td class="pr-4">Opcional</td><td>Teléfono de contacto</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">carrera</td><td class="pr-4">Opcional</td><td>Carrera / programa</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">semestre</td><td class="pr-4">Opcional</td><td>Semestre actual</td></tr>
                        <tr><td class="pr-4 py-1 font-mono">numero_control</td><td class="pr-4">Opcional</td><td>Número de control</td></tr>
                    </tbody>
                </table>
            </div>
        </div>

        {{-- Upload Zone --}}
        <div wire:loading.class="opacity-50 pointer-events-none">
            <label class="block">
                <div class="border-2 border-dashed border-gray-300 rounded-xl p-10 text-center cursor-pointer hover:border-blue-400 hover:bg-blue-50 transition-all group">
                    <svg class="w-12 h-12 text-gray-400 group-hover:text-blue-500 mx-auto mb-4 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                    </svg>
                    @if($archivoNombre)
                        <p class="text-base font-semibold text-blue-700">{{ $archivoNombre }}</p>
                        <p class="text-sm text-gray-500 mt-1">Archivo cargado. Procesando...</p>
                    @else
                        <p class="text-base font-semibold text-gray-700 group-hover:text-blue-700">
                            Arrastra tu archivo aquí o haz clic para seleccionar
                        </p>
                        <p class="text-sm text-gray-400 mt-1">CSV, XLS, XLSX · Máx. 5MB</p>
                    @endif
                </div>
                <input type="file" wire:model="archivo" accept=".csv,.xlsx,.xls" class="hidden">
            </label>
        </div>

        {{-- Loading indicator --}}
        <div wire:loading wire:target="archivo" class="mt-4 flex items-center justify-center space-x-2 text-blue-600">
            <svg class="animate-spin w-5 h-5" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path>
            </svg>
            <span class="text-sm font-medium">Procesando archivo...</span>
        </div>

        @error('archivo')
            <p class="mt-3 text-sm text-red-600 bg-red-50 rounded-lg px-3 py-2">{{ $message }}</p>
        @enderror
    </div>
    @endif

    {{-- ===================== STEP 2: PREVIEW ===================== --}}
    @if($step == 2)
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h2 class="text-lg font-semibold text-gray-900">Paso 2: Vista Previa</h2>
                <p class="text-sm text-gray-500">
                    Archivo: <strong>{{ $archivoNombre }}</strong> —
                    <span class="text-blue-600 font-medium">{{ $totalFilas }} registro(s) encontrado(s)</span>
                    @if($totalFilas > 100) · Mostrando primeros 100 @endif
                </p>
            </div>
            <button wire:click="regresarAUpload" class="text-sm text-gray-500 hover:text-gray-800 flex items-center space-x-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                <span>Cambiar archivo</span>
            </button>
        </div>

        {{-- Validation Errors --}}
        @if(!empty($erroresValidacion))
        <div class="mb-4 bg-red-50 border border-red-200 rounded-xl p-4">
            <div class="flex items-center space-x-2 mb-2">
                <svg class="w-5 h-5 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"/>
                </svg>
                <h3 class="text-sm font-semibold text-red-800">Se encontraron {{ count($erroresValidacion) }} problema(s):</h3>
            </div>
            <ul class="space-y-1 max-h-32 overflow-y-auto">
                @foreach(array_slice($erroresValidacion, 0, 10) as $error)
                    <li class="text-xs text-red-700 flex items-start space-x-1">
                        <span class="text-red-400 mt-0.5">•</span>
                        <span>{{ $error }}</span>
                    </li>
                @endforeach
            </ul>
            @if(count($erroresValidacion) > 10)
                <p class="text-xs text-red-600 mt-2">... y {{ count($erroresValidacion) - 10 }} error(es) más</p>
            @endif
        </div>
        @else
        <div class="mb-4 bg-green-50 border border-green-200 rounded-xl p-3 flex items-center space-x-2">
            <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/>
            </svg>
            <p class="text-sm text-green-700 font-medium">Estructura válida. {{ $totalFilas }} registros listos para importar.</p>
        </div>
        @endif

        {{-- Data Table --}}
        <div class="overflow-x-auto rounded-xl border border-gray-200">
            <table class="w-full text-sm">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-gray-500 uppercase">#</th>
                        @foreach($headers as $header)
                            <th class="px-3 py-2 text-left text-xs font-semibold text-gray-500 uppercase">{{ $header }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($previewData as $idx => $row)
                    <tr class="hover:bg-gray-50">
                        <td class="px-3 py-2 text-gray-400 text-xs">{{ $idx + 1 }}</td>
                        @foreach($headers as $header)
                            <td class="px-3 py-2 text-gray-700 max-w-xs truncate">
                                @if($header === 'email' && !filter_var($row[$header] ?? '', FILTER_VALIDATE_EMAIL))
                                    <span class="text-red-500">{{ $row[$header] ?? '-' }}</span>
                                @elseif(empty($row[$header] ?? ''))
                                    <span class="text-gray-300">—</span>
                                @else
                                    {{ $row[$header] }}
                                @endif
                            </td>
                        @endforeach
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="flex justify-between mt-6">
            <button wire:click="regresarAUpload"
                    class="px-4 py-2 border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition">
                Cancelar
            </button>
            <button wire:click="avanzarASeleccionTutor"
                    @if(!$previewValido && count($erroresValidacion) >= 5) disabled @endif
                    class="px-6 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition disabled:opacity-50 disabled:cursor-not-allowed">
                Continuar →
            </button>
        </div>
    </div>
    @endif

    {{-- ===================== STEP 3: ASSIGN TUTOR ===================== --}}
    @if($step == 3)
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 max-w-2xl mx-auto">
        <h2 class="text-lg font-semibold text-gray-900 mb-2">Paso 3: Asignar Tutor</h2>
        <p class="text-sm text-gray-500 mb-6">
            Selecciona el tutor que recibirá los <strong>{{ $totalFilas }}</strong> tutorados de este archivo.
        </p>

        <div class="mb-6">
            <label class="block text-sm font-medium text-gray-700 mb-2">Seleccionar Tutor *</label>
            <select wire:model="tutorSeleccionado"
                    class="w-full rounded-xl border-gray-300 text-sm shadow-sm focus:border-blue-500 focus:ring-blue-500">
                <option value="">-- Selecciona un tutor --</option>
                @foreach($tutores as $tutor)
                    <option value="{{ $tutor->id }}">
                        {{ $tutor->name }} ({{ $tutor->codigo ?? $tutor->email }})
                        — {{ $tutor->tutoradosAsignados->count() }} tutorados actuales
                    </option>
                @endforeach
            </select>
            @error('tutorSeleccionado') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
            @error('selectedTutorId') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
        </div>

        {{-- Summary before confirm --}}
        @if($tutorSeleccionado)
        @php $tutorSelec = $tutores->find($tutorSeleccionado) @endphp
        <div class="bg-blue-50 rounded-xl p-4 mb-6">
            <h3 class="text-sm font-semibold text-blue-900 mb-2">Resumen de la operación:</h3>
            <ul class="text-sm text-blue-700 space-y-1">
                <li>• <strong>{{ $totalFilas }}</strong> registros en el archivo</li>
                <li>• Tutor destino: <strong>{{ $tutorSelec?->name }}</strong></li>
                <li>• Se crearán usuarios nuevos con contraseña temporal</li>
                <li>• Los emails duplicados se actualizarán y reasignarán</li>
            </ul>
        </div>
        @endif

        {{-- Confirm dialog --}}
        @if($confirmarImportacion)
        <div class="bg-amber-50 border border-amber-200 rounded-xl p-4 mb-6">
            <p class="text-sm font-semibold text-amber-800 mb-3">
                ⚠️ ¿Confirmas la importación de {{ $totalFilas }} registros?
            </p>
            <p class="text-xs text-amber-700 mb-4">Esta acción creará/actualizará usuarios y asignará tutor. No se puede deshacer fácilmente.</p>
            <div class="flex space-x-3">
                <button wire:click="ejecutarImportacion"
                        wire:loading.attr="disabled"
                        class="px-5 py-2 bg-amber-600 text-white text-sm font-semibold rounded-lg hover:bg-amber-700 transition">
                    <span wire:loading.remove wire:target="ejecutarImportacion">✓ Confirmar Importación</span>
                    <span wire:loading wire:target="ejecutarImportacion" class="flex items-center space-x-2">
                        <svg class="animate-spin w-4 h-4" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path>
                        </svg>
                        <span>Importando...</span>
                    </span>
                </button>
                <button wire:click="$set('confirmarImportacion', false)"
                        class="px-4 py-2 border border-gray-300 text-gray-700 text-sm rounded-lg hover:bg-gray-50">
                    Cancelar
                </button>
            </div>
        </div>
        @endif

        <div class="flex justify-between">
            <button wire:click="regresarAPreview"
                    class="px-4 py-2 border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50">
                ← Regresar
            </button>
            @if(!$confirmarImportacion)
            <button wire:click="confirmar"
                    class="px-6 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                Importar Ahora
            </button>
            @endif
        </div>
    </div>
    @endif

    {{-- ===================== STEP 4: RESULTS ===================== --}}
    @if($step == 4)
    <div class="max-w-3xl mx-auto">
        {{-- Result Summary --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 mb-6">
            <div class="text-center mb-6">
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                    <svg class="w-8 h-8 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/>
                    </svg>
                </div>
                <h2 class="text-xl font-bold text-gray-900">¡Importación Completada!</h2>
                <p class="text-gray-500 text-sm mt-1">Archivo: {{ $archivoNombre }}</p>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <div class="text-center bg-green-50 rounded-xl p-4">
                    <p class="text-3xl font-bold text-green-600">{{ $resultados['creados'] ?? 0 }}</p>
                    <p class="text-xs text-green-700 font-medium mt-1">Creados</p>
                </div>
                <div class="text-center bg-blue-50 rounded-xl p-4">
                    <p class="text-3xl font-bold text-blue-600">{{ $resultados['actualizados'] ?? 0 }}</p>
                    <p class="text-xs text-blue-700 font-medium mt-1">Actualizados</p>
                </div>
                <div class="text-center bg-gray-50 rounded-xl p-4">
                    <p class="text-3xl font-bold text-gray-500">{{ $resultados['omitidos'] ?? 0 }}</p>
                    <p class="text-xs text-gray-600 font-medium mt-1">Omitidos</p>
                </div>
                <div class="text-center @if($resultados['errores'] ?? 0 > 0) bg-red-50 @else bg-gray-50 @endif rounded-xl p-4">
                    <p class="text-3xl font-bold @if($resultados['errores'] ?? 0 > 0) text-red-500 @else text-gray-400 @endif">
                        {{ $resultados['errores'] ?? 0 }}
                    </p>
                    <p class="text-xs @if($resultados['errores'] ?? 0 > 0) text-red-600 @else text-gray-500 @endif font-medium mt-1">Errores</p>
                </div>
            </div>
        </div>

        {{-- Generated Credentials (Admin Only) --}}
        @if(!empty($credencialesGeneradas))
        <div class="bg-white rounded-2xl shadow-sm border border-amber-200 p-6 mb-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="w-8 h-8 bg-amber-100 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-amber-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 8a6 6 0 01-7.743 5.743L10 14l-1 1-1 1H6v2H2v-4l4.257-4.257A6 6 0 1118 8zm-6-4a1 1 0 100 2 2 2 0 012 2 1 1 0 102 0 4 4 0 00-4-4z"/>
                    </svg>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900">Credenciales Generadas</h3>
                    <p class="text-xs text-amber-600">⚠️ Visible solo para administradores. Comparte con cuidado.</p>
                </div>
            </div>

            <div class="overflow-x-auto rounded-xl border border-amber-200">
                <table class="w-full text-sm">
                    <thead class="bg-amber-50">
                        <tr>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-amber-800 uppercase">Nombre</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-amber-800 uppercase">Email</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-amber-800 uppercase">Código</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-amber-800 uppercase">Contraseña Temporal</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-amber-100">
                        @foreach($credencialesGeneradas as $cred)
                        <tr class="hover:bg-amber-50">
                            <td class="px-3 py-2 text-gray-800 font-medium">{{ $cred['nombre'] }}</td>
                            <td class="px-3 py-2 text-gray-600">{{ $cred['email'] }}</td>
                            <td class="px-3 py-2 text-gray-600">{{ $cred['codigo'] }}</td>
                            <td class="px-3 py-2">
                                <code class="bg-amber-100 text-amber-800 px-2 py-0.5 rounded font-mono text-xs">
                                    {{ $cred['password_temporal'] }}
                                </code>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <p class="text-xs text-gray-400 mt-3">
                Se recomienda solicitar a los estudiantes que cambien su contraseña en el primer inicio de sesión.
            </p>
        </div>
        @endif

        <div class="flex justify-center space-x-4">
            <button wire:click="nuevaImportacion"
                    class="px-6 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                Nueva Importación
            </button>
            <a href="{{ route('admin.users') }}"
               class="px-6 py-2 border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition">
                Ver Usuarios
            </a>
        </div>
    </div>
    @endif
</div>
