<div>
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Gestión de Usuarios</h1>
            <p class="text-gray-500 text-sm mt-1">Administra tutores y tutorados del sistema</p>
        </div>
        <div class="flex space-x-2">
            <a href="{{ route('admin.export.users') }}"
               class="inline-flex items-center px-3 py-2 border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition">
                <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                </svg>
                Exportar
            </a>
            <button wire:click="openCreateModal"
                    class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition shadow-sm">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                </svg>
                Nuevo Usuario
            </button>
        </div>
    </div>

    {{-- Filters --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="md:col-span-2">
                <div class="relative">
                    <svg class="absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <input type="text" wire:model.debounce.300ms="search"
                           placeholder="Buscar por nombre, email o código..."
                           class="w-full pl-10 pr-4 py-2 text-sm border border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500">
                </div>
            </div>
            <select wire:model="filterRol" class="text-sm border border-gray-300 rounded-xl focus:border-blue-500">
                <option value="">Todos los roles</option>
                <option value="administrador">Administrador</option>
                <option value="tutor">Tutor</option>
                <option value="tutorado">Tutorado</option>
            </select>
            <select wire:model="filterEstado" class="text-sm border border-gray-300 rounded-xl focus:border-blue-500">
                <option value="">Todos los estados</option>
                <option value="1">Activos</option>
                <option value="0">Inactivos</option>
            </select>
        </div>
    </div>

    {{-- Users Table --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50 border-b border-gray-200">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Usuario</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Código</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Rol</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tutor Asignado</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estado</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($users as $user)
                    <tr class="hover:bg-gray-50 transition">
                        <td class="px-4 py-3">
                            <div class="flex items-center space-x-3">
                                <img class="w-8 h-8 rounded-full ring-1 ring-gray-200"
                                     src="{{ $user->profile_photo_url }}" alt="{{ $user->name }}">
                                <div>
                                    <p class="font-medium text-gray-900">{{ $user->name }}</p>
                                    <p class="text-xs text-gray-400">{{ $user->email }}</p>
                                </div>
                            </div>
                        </td>
                        <td class="px-4 py-3 text-gray-600 font-mono text-xs">{{ $user->codigo ?? '—' }}</td>
                        <td class="px-4 py-3">
                            @if($user->roles->isNotEmpty())
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                    @if($user->hasRole('administrador')) bg-purple-100 text-purple-700
                                    @elseif($user->hasRole('tutor')) bg-blue-100 text-blue-700
                                    @else bg-green-100 text-green-700 @endif">
                                    {{ $user->rol_display }}
                                </span>
                            @else
                                <span class="text-gray-400 text-xs">Sin rol</span>
                            @endif
                        </td>
                        <td class="px-4 py-3 text-gray-600 text-xs">
                            @if($user->hasRole('tutorado'))
                                @if($user->tutorAsignado)
                                    <span class="text-blue-600 font-medium">{{ $user->tutorAsignado->tutor?->name }}</span>
                                @else
                                    <span class="text-amber-500">Sin asignar</span>
                                @endif
                            @else
                                <span class="text-gray-300">N/A</span>
                            @endif
                        </td>
                        <td class="px-4 py-3">
                            <button wire:click="toggleActivo({{ $user->id }})"
                                    class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium cursor-pointer
                                        @if($user->activo) bg-green-100 text-green-700 hover:bg-green-200
                                        @else bg-red-100 text-red-700 hover:bg-red-200 @endif transition">
                                {{ $user->activo ? 'Activo' : 'Inactivo' }}
                            </button>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center justify-end space-x-1">
                                @if($user->hasRole('tutorado'))
                                <button wire:click="openAsignModal({{ $user->id }})"
                                        title="Asignar Tutor"
                                        class="p-1.5 text-blue-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                </button>
                                @endif
                                <button wire:click="openEditModal({{ $user->id }})"
                                        title="Editar"
                                        class="p-1.5 text-gray-400 hover:text-gray-700 hover:bg-gray-100 rounded-lg transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </button>
                                <button wire:click="openResetModal({{ $user->id }})"
                                        title="Restablecer contraseña"
                                        class="p-1.5 text-gray-400 hover:text-amber-600 hover:bg-amber-50 rounded-lg transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"/>
                                    </svg>
                                </button>
                                @if($user->id !== auth()->id())
                                <button wire:click="deleteUser({{ $user->id }})"
                                        wire:confirm="¿Seguro que deseas eliminar a {{ $user->name }}? Se hará soft delete."
                                        title="Eliminar"
                                        class="p-1.5 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                    </svg>
                                </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-4 py-12 text-center text-gray-400">
                            <svg class="w-12 h-12 mx-auto mb-3 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <p class="font-medium">No se encontraron usuarios</p>
                            <p class="text-sm mt-1">Intenta ajustar los filtros de búsqueda</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div class="px-4 py-3 border-t border-gray-200">
            {{ $users->links() }}
        </div>
    </div>

    {{-- ===================== MODAL: CREATE/EDIT USER ===================== --}}
    @if($showModal)
    <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4" wire:click.self="$set('showModal', false)">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                <h3 class="text-base font-semibold text-gray-900">
                    {{ $editMode ? 'Editar Usuario' : 'Nuevo Usuario' }}
                </h3>
                <button wire:click="$set('showModal', false)" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"/>
                    </svg>
                </button>
            </div>
            <div class="p-6 space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre completo *</label>
                    <input type="text" wire:model="nombre" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500" placeholder="Ej: María González Pérez">
                    @error('nombre') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Código institucional</label>
                        <input type="text" wire:model="codigo" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500" placeholder="Ej: 20230001">
                        @error('codigo') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Teléfono</label>
                        <input type="text" wire:model="telefono" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500" placeholder="Ej: 8441234567">
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email *</label>
                    <input type="email" wire:model="email" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500" placeholder="usuario@universidad.edu">
                    @error('email') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Rol *</label>
                    <select wire:model="rol" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500 focus:ring-blue-500">
                        <option value="">-- Seleccionar rol --</option>
                        <option value="administrador">Administrador</option>
                        <option value="tutor">Tutor</option>
                        <option value="tutorado">Tutorado</option>
                    </select>
                    @error('rol') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>
                <div class="flex items-center space-x-2">
                    <input type="checkbox" wire:model="activo" id="activo" class="rounded border-gray-300 text-blue-600">
                    <label for="activo" class="text-sm text-gray-700">Cuenta activa</label>
                </div>
                @if(!$editMode)
                <p class="text-xs text-blue-600 bg-blue-50 rounded-lg px-3 py-2">
                    Se generará una contraseña temporal automáticamente.
                </p>
                @endif
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                <button wire:click="$set('showModal', false)" class="px-4 py-2 border border-gray-300 text-gray-700 text-sm rounded-lg hover:bg-gray-100">Cancelar</button>
                <button wire:click="save" class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    {{ $editMode ? 'Guardar Cambios' : 'Crear Usuario' }}
                </button>
            </div>
        </div>
    </div>
    @endif

    {{-- ===================== MODAL: ASSIGN TUTOR ===================== --}}
    @if($showAsignModal)
    <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4" wire:click.self="$set('showAsignModal', false)">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-md overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                <h3 class="text-base font-semibold text-gray-900">Asignar Tutor</h3>
            </div>
            <div class="p-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Seleccionar Tutor *</label>
                <select wire:model="selectedTutorId" class="w-full text-sm border-gray-300 rounded-xl focus:border-blue-500">
                    <option value="">-- Seleccionar tutor --</option>
                    @foreach($tutores as $tutor)
                        <option value="{{ $tutor->id }}">{{ $tutor->name }}</option>
                    @endforeach
                </select>
                @error('selectedTutorId') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                <button wire:click="$set('showAsignModal', false)" class="px-4 py-2 border border-gray-300 text-gray-700 text-sm rounded-lg hover:bg-gray-100">Cancelar</button>
                <button wire:click="asignarTutor" class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700">Asignar</button>
            </div>
        </div>
    </div>
    @endif

    {{-- ===================== MODAL: RESET PASSWORD ===================== --}}
    @if($showResetModal)
    <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4" wire:click.self="$set('showResetModal', false)">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-md overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                <h3 class="text-base font-semibold text-gray-900">Restablecer Contraseña</h3>
            </div>
            <div class="p-6 space-y-4">
                <div class="flex space-x-3">
                    <input type="text" wire:model="generatedPassword"
                           class="flex-1 text-sm border-gray-300 rounded-xl focus:border-blue-500 font-mono"
                           placeholder="Nueva contraseña o genera una automática">
                    <button wire:click="generarPassword"
                            class="px-4 py-2 bg-gray-100 text-gray-700 text-sm rounded-xl hover:bg-gray-200 transition whitespace-nowrap">
                        Generar
                    </button>
                </div>
                @error('generatedPassword') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
                @if($generatedPassword)
                <div class="bg-amber-50 border border-amber-200 rounded-xl px-4 py-3">
                    <p class="text-xs text-amber-700">Nueva contraseña: <code class="font-mono font-bold">{{ $generatedPassword }}</code></p>
                    <p class="text-xs text-amber-600 mt-1">Copia esta contraseña antes de confirmar.</p>
                </div>
                @endif
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                <button wire:click="$set('showResetModal', false)" class="px-4 py-2 border border-gray-300 text-gray-700 text-sm rounded-lg hover:bg-gray-100">Cancelar</button>
                <button wire:click="confirmarReset" class="px-5 py-2 bg-amber-600 text-white text-sm font-medium rounded-lg hover:bg-amber-700">Confirmar Reset</button>
            </div>
        </div>
    </div>
    @endif
</div>
