<div>
    <div class="flex items-center justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Mi Panel de Tutoría</h1>
            <p class="text-gray-500 text-sm mt-1">Bienvenido, {{ auth()->user()->name }}</p>
        </div>
        <a href="{{ route('tutor.sessions') }}"
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition shadow-sm">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Nueva Sesión
        </a>
    </div>

    {{-- Stats --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Mis Tutorados</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $totalTutorados }}</p>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                    </svg>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Sesiones (este mes)</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $sesionesEsteMes }}</p>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500">Nuevos (30 días)</p>
                    <p class="text-3xl font-bold text-gray-900 mt-1">{{ $tutoradosRecientes }}</p>
                </div>
                <div class="w-12 h-12 bg-purple-100 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        {{-- My Tutorados --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-base font-semibold text-gray-900">Mis Tutorados</h2>
                <a href="{{ route('tutor.sessions') }}" class="text-xs text-blue-600 hover:underline">Ver sesiones</a>
            </div>
            <div class="space-y-3">
                @forelse($tutoradosLista as $tutorado)
                <div class="flex items-center space-x-3 p-3 rounded-xl hover:bg-gray-50 transition">
                    <div class="w-9 h-9 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white text-sm font-bold flex-shrink-0">
                        {{ strtoupper(substr($tutorado['nombre'], 0, 1)) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="font-medium text-gray-900 text-sm truncate">{{ $tutorado['nombre'] }}</p>
                        <p class="text-xs text-gray-400 truncate">
                            {{ $tutorado['carrera'] ?? $tutorado['email'] }}
                            @if($tutorado['carrera']) · Sem. {{ $tutorado['semestre'] ?? '?' }} @endif
                        </p>
                    </div>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                        @if($tutorado['estado'] === 'regular') bg-green-100 text-green-700
                        @elseif($tutorado['estado'] === 'irregular') bg-yellow-100 text-yellow-700
                        @else bg-red-100 text-red-700 @endif">
                        {{ ucfirst($tutorado['estado']) }}
                    </span>
                </div>
                @empty
                <p class="text-sm text-gray-400 text-center py-8">No tienes tutorados asignados aún.</p>
                @endforelse
            </div>
        </div>

        {{-- Upcoming Sessions --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-base font-semibold text-gray-900">Próximas Sesiones</h2>
                <a href="{{ route('tutor.sessions') }}" class="text-xs text-blue-600 hover:underline">Gestionar</a>
            </div>
            @forelse($proximasSesiones as $sesion)
            <div class="flex items-start space-x-3 p-3 bg-blue-50 rounded-xl mb-3">
                <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center flex-shrink-0 text-white text-xs font-bold">
                    {{ \Carbon\Carbon::parse($sesion['fecha'])->format('d') }}<br>
                    <span class="text-xs">{{ \Carbon\Carbon::parse($sesion['fecha'])->format('M') }}</span>
                </div>
                <div>
                    <p class="font-medium text-blue-900 text-sm">{{ $sesion['tutorado'] }}</p>
                    <p class="text-xs text-blue-600 truncate">{{ $sesion['tema'] }}</p>
                </div>
            </div>
            @empty
            <p class="text-sm text-gray-400 text-center py-8">No hay sesiones pendientes programadas.</p>
            @endforelse
        </div>
    </div>
</div>
